//_3190S19
//
//*************************************************************************
//Bibliotheken
//*************************************************************************
#include <Adafruit_RGBLCDShield.h>
Adafruit_RGBLCDShield lcd = Adafruit_RGBLCDShield();

//*************************************************************************
//Definitionen 
//*************************************************************************
int i = 0;
int t = 5;
int d = 100;
int V;
int S;
boolean P_Teil_Status;
uint8_t buttons;
int HIGH_U =6;
int LOW_U =5;
int HIGH_V =9;
int LOW_V =10;
int HIGH_W =11;
int LOW_W =3;
int Trigger =2;
  
//*************************************************************************
//Initialisierung 
//*************************************************************************
void setup()
{
  Serial.begin(9600);
  P_Teil_Status = false; 
  lcd.begin(16, 4);             // Spalte 0, Zeile 0 ==> Home
    
  pinMode(HIGH_W,OUTPUT);       // OC2A
  pinMode(HIGH_V,OUTPUT);       // OC1A
  pinMode(HIGH_U,OUTPUT);       // OC0A
  pinMode(LOW_W,OUTPUT);        // OC2B
  pinMode(LOW_V,OUTPUT);        // OC1B
  pinMode(LOW_U,OUTPUT);        // OC0B

  pinMode (Trigger,OUTPUT);

  delay(1000);
  lcd.clear();
  lcd.print ("Taster - Test!");
  P_Teil();
}

//*************************************************************************
void P_Teil()
{
  buttons = lcd.readButtons();
  if( buttons !=1 ) 
    {
      P_Teil_Status = false;
    }
  else
    {
    P_Teil_Status = true;
    }
}

//*************************************************************************

//*************************************************************************
void weiterschalten()
{
  delay(500); 
  do
    {
     buttons = lcd.readButtons();
    }
  while(buttons ==!1);
}
 
//*************************************************************************
void pruefung_1()
{
  lcd.clear();
  lcd.print ("Pruefung!");
  delay(1000);
  lcd.clear();
  lcd.print ("Oszilloskopiere");
  lcd.setCursor(0,1);     //2. Zeile
  lcd.print ("Phase U, V und W");
  lcd.setCursor(16,0);     //3. Zeile
  lcd.print ("Bearbeiten Sie  ");
  lcd.setCursor(16,1);     //4. Zeile
  lcd.print ("Blatt 5 Aufg. 1");
  
  do
  {
  int D=analogRead(A0);     //Drehzahl
  int d = map(D, 0, 1023, 4, 50);
  
  digitalWrite (Trigger, HIGH);      // für Messung
  delay(1);
  digitalWrite (Trigger, LOW);

// 1. Step
  digitalWrite (HIGH_U,LOW);        
  digitalWrite (LOW_U,LOW);          
  digitalWrite (HIGH_V,HIGH);         
  digitalWrite (LOW_V,LOW);      
  digitalWrite (HIGH_W,LOW);          
  digitalWrite (LOW_W,HIGH);           
  delay(d);
// 2. Step
  digitalWrite (HIGH_U,HIGH);        
  digitalWrite (HIGH_V,LOW);         
  delay(d); 
// 3. Step
  digitalWrite (LOW_V,HIGH);      
  digitalWrite (LOW_W,LOW);
  delay(d);
// 4. Step
  digitalWrite(HIGH_U,LOW);        
  digitalWrite (HIGH_W,HIGH);          
  digitalWrite (LOW_W,LOW);
  delay(d);
// 5. Step
  digitalWrite (LOW_U,HIGH);          
  digitalWrite (LOW_V,LOW);      
  delay(d);
// 6. Step
  digitalWrite (HIGH_V,HIGH);         
  digitalWrite (HIGH_W,LOW);          
  delay(d);
    
  buttons = lcd.readButtons();       
  }
  while (buttons ==!3); 
}
//*************************************************************************      
//*************************************************************************
void pruefung_2()
{
  lcd.clear();
  lcd.print ("Pruefung!");
  delay(1000);
  lcd.clear();
  lcd.print ("Oszilloskopiere");
  lcd.setCursor(0,1);     //2. Zeile
  lcd.print ("Zeichenausgabe");
  lcd.setCursor(16,0);     //3. Zeile
  lcd.print ("Bearbeiten Sie  ");
  lcd.setCursor(16,1);     //4. Zeile  
  lcd.print ("Blatt 5 Aufg. 2");
  
  do
  {
  digitalWrite (Trigger, LOW);      // für Messung
  delay(1);
  digitalWrite (Trigger, HIGH);
  Serial.print ("XY");
  delay(1);
  buttons = lcd.readButtons();       
  }
  while (buttons ==!3); 
    
}
//*************************************************************************
void neutral()
{
  digitalWrite(HIGH_U,LOW);     // Grundeinstellung 
  digitalWrite(LOW_U,LOW);
  digitalWrite(HIGH_V,LOW);
  digitalWrite(LOW_V,LOW);
  digitalWrite(HIGH_W,LOW);    
  digitalWrite(LOW_W,LOW);
  delay (d); 
}
//*************************************************************************

//*************************************************************************
//Hauptprogramm 
//*************************************************************************
void loop()
{
  if( P_Teil_Status == true )
  {
    pruefung_1();
    pruefung_2();
    lcd.clear();
    lcd.setCursor(4,0);     //2. Zeile
    lcd.print ("Ende");
    lcd.setCursor(5,1);     //2. Zeile
    lcd.print ("der");
    lcd.setCursor(22,0);     //3. Zeile
    lcd.print ("Messungen");
    while (true) {/*Endlosschleife*/}
  }
  else
    buttons = lcd.readButtons();
 
  switch (buttons)
  {
//*************************************************************************
    case 1:
      lcd.setCursor(16,1);  //Trick 1. Position auf Zeile 4
      lcd.print("SELECT ");
      break; 
//*************************************************************************
    case 2:
      lcd.setCursor(16,1);  //Trick 1. Position auf Zeile 4
      lcd.print("RIGHT ");
      break;
//*************************************************************************
    case 4:
      lcd.setCursor(16,1);  //Trick 1. Position auf Zeile 4
      lcd.print("DOWN ");
      break;  
//*************************************************************************
    case 3:
      lcd.clear(); 
      lcd.print("Strang - Test!");
      lcd.setCursor(16,0);    //Trick 1. Position auf Zeile 3
      lcd.print("1. Strang W / V ");
      digitalWrite (HIGH_W,HIGH);         
      digitalWrite (LOW_V,HIGH);
      weiterschalten();
      neutral();
       
      lcd.setCursor(16,0);  //Trick 1. Position auf Zeile 3
      lcd.print("2. Strang U / V ");
      digitalWrite (HIGH_U,HIGH);        
      digitalWrite (LOW_V,HIGH);
      weiterschalten();
      neutral();
              
      lcd.setCursor(16,0);  //Trick 1. Position auf Zeile 3
      lcd.print("3. Strang U / W ");
      digitalWrite (HIGH_U,HIGH);      
      digitalWrite (LOW_W,HIGH);
      weiterschalten();
      neutral();
       
      lcd.setCursor(16,0);  //Trick 1. Position auf Zeile 3
      lcd.print("4. Strang V / W ");
      digitalWrite (HIGH_V,HIGH);        
      digitalWrite (LOW_W,HIGH);
      weiterschalten();
      neutral();
       
      lcd.setCursor(16,0);  //Trick 1. Position auf Zeile 3
      lcd.print("5. Strang V / U ");
      digitalWrite (HIGH_V,HIGH);        
      digitalWrite (LOW_U,HIGH);
      weiterschalten();
      neutral();
       
      lcd.setCursor(16,0);  //Trick 1. Position auf Zeile 3
      lcd.print("6. Strang W / U ");
      digitalWrite (HIGH_W,HIGH);        
      digitalWrite (LOW_U,HIGH);
      weiterschalten();
      neutral();
       
      lcd.clear();
      
      lcd.print ("Taster - Test!");
      break;
//*************************************************************************
    case 6:
      lcd.clear();
      lcd.print ("Analog - Test!");
              
      do
      {
        V=analogRead(A0);     
        S = analogRead(A1);   
        lcd.setCursor(0,2);
        lcd.print("AD0 =     ");
        lcd.setCursor(6,2);
        lcd.print(V);
        lcd.setCursor(0,3);
        lcd.print("AD1 =     ");
        lcd.setCursor(6,3);
        lcd.print(S);
        delay(d);
        buttons = lcd.readButtons();
      }
      while (buttons ==!1); 
      
      lcd.clear();
      lcd.print ("Taster - Test!");
      break;
 //*************************************************************************
 case 5:
      lcd.clear();
      lcd.print ("Trigger - Test!");
      lcd.setCursor(16,0);       //Trick 1. Position auf Zeile 3
      lcd.print ("Frequenz -MP24");   
      delay(1000);                                      // Änderung sicher in den Trigger-Test
      
      do
      {
        digitalWrite(Trigger,HIGH);     // Grundeinstellung 
        delay(10);
        digitalWrite(Trigger,LOW);
       // delay(10);
        buttons = lcd.readButtons();        
      }
      while (buttons ==!1);
      
      lcd.clear();
      lcd.print ("Taster - Test!");
      break;
//************************************************************************* 
  }
}
