#include <SPI.h>

// Ansteuerung einer RGB LED mittels dreier MCP4151-103 und TLC271
// Pulsweitenmodulation von Dreieckspannung TL 555
// D2 Taster Increment
// D3 Taster Farbwahl (modulo rot gruen blau)
// D4 Taster Decrement
// D5 Kontroll-LED rot
// D6 /CS gruen
// D7 Kontroll-LED gruen
// D8 Kontroll-LED blau
// D9 /CS rot
// D10 /CS blau
// D11 Daten fuer SPI Bus zum MCP 4151
// D13 Takt fuer SPI Bus zum MCP 4151 
// 
const int csrot = 9;
const int csgruen = 6;
const int csblau = 10;
int erhoeh;
int verring;
int farbe;
int altwert;
int wert;
int wertrot;
int altwertrot;
int wertgruen;
int altwertgruen;
int wertblau;
int altwertblau;
int entprellzeit = 100;
int tasterstatusfarbe = HIGH;
int tasterstatusincrement = HIGH;
int tasterstatusdecrement = HIGH;
int tastergedruecktfarbe = 0;
int tastergedruecktincrement = 0;
int tastergedruecktdecrement = 0;
unsigned long tasterzeitfarbe = 0;
unsigned long tasterzeitincrement = 0;
unsigned long tasterzeitdecrement = 0;
int rotArray[] = {5,20,40,80,100,128,150,180,220,255};
int gruenArray[] = {5,20,40,80,100,128,150,180,220,255};
int blauArray[] = {5,20,40,80,100,128,150,180,220,255};
int indexrot;
int indexgruen;
int indexblau;

// 

void setup() 
{
pinMode(csrot,OUTPUT);   //CS rot
pinMode(csgruen, OUTPUT);  //CS gruen
pinMode(csblau,OUTPUT);  //CS blau
pinMode(5,OUTPUT);  //Kontroll-LED rot
pinMode(7,OUTPUT);  // Kontroll-LED gruen
pinMode(8,OUTPUT);  //Kontroll-LED blau
pinMode(2,INPUT);  // Taster Increment
pinMode(3,INPUT);   //Taster Farbwahl
pinMode(4,INPUT);   //Taster Decrement
digitalWrite(csrot,HIGH);
digitalWrite(csgruen,HIGH);
digitalWrite(csblau,HIGH);
digitalWrite(5,HIGH);
digitalWrite(7,HIGH);
digitalWrite(8,HIGH);
farbe = 0;
indexrot = 5;
indexgruen = 5;
indexblau = 5; 
wertrot = rotArray[5];
wertgruen = gruenArray[5];
wertblau = blauArray[5];
SPI.begin(); 
}

void tastefarbe()
{
 tasterstatusfarbe = digitalRead(3);
 if(tasterstatusfarbe == LOW)
 {
  tasterzeitfarbe = millis(); 
  tastergedruecktfarbe = 1;
 }
 if ((millis() - tasterzeitfarbe > entprellzeit ) && tastergedruecktfarbe ==1)
 {
  tastergedruecktfarbe = 0;
   farbe = ((farbe + 1) % 3);   // modulo 0,1,2
 }
} 

void tasteincrement()
{
 tasterstatusincrement = digitalRead(2);
 if(tasterstatusincrement == LOW)
 {
  tasterzeitincrement = millis(); 
  tastergedruecktincrement = 1;
 }
 if ((millis() - tasterzeitincrement > entprellzeit ) && tastergedruecktincrement ==1)
 { 
 erhoeh = 1;
    tastergedruecktincrement = 0;
 }  
} 

void tastedecrement()
{
  tasterstatusdecrement = digitalRead(4);
 if(tasterstatusdecrement == LOW)
 {
  tasterzeitdecrement = millis(); 
  tastergedruecktdecrement = 1;
 }
 if ((millis() - tasterzeitdecrement > entprellzeit ) && tastergedruecktdecrement ==1)
 {
  verring = 1;
  tastergedruecktdecrement = 0;
 }
 }
 

void loop() 
{
tastefarbe();    // Wurde farbwechsel aktiviert ?
tastedecrement();
tasteincrement();
 switch (farbe) 
  {
  case 0:
         if( erhoeh == 1 && indexrot < 9)
         {
          indexrot = indexrot + 1;
         }
         if (verring == 1  && indexrot > 0)
         {
          indexrot = indexrot - 1;
         }
         digitalWrite(9,LOW);   //CS rot               aktiv
         digitalWrite(5,LOW);   // Kontrol-LED rot     aktiv
         digitalWrite(6,HIGH);  //CS gruen
         digitalWrite(7,HIGH);  //Kontroll-LED gruen
         digitalWrite(10,HIGH); // CS blau
         digitalWrite(8,HIGH) ; // Kontroll-LED blau
         wertrot = rotArray[indexrot];
         SPI.transfer(0);
         SPI.transfer(wertrot);
         digitalWrite(9 ,HIGH);
         erhoeh = 0;
         verring = 0; 
  break;  
  case 1 :
           if( erhoeh == 1 && indexgruen < 9)
         {
          indexgruen = indexgruen + 1;
         }
         if (verring == 1  && indexgruen > 0)
         {
          indexgruen = indexgruen - 1;
         }
         digitalWrite(9,HIGH);   //CS rot
         digitalWrite(5,HIGH);   // Kontrol-LED rot
         digitalWrite(6,LOW);  //CS gruen               aktiv
         digitalWrite(7,LOW);  //Kontroll-LED gruen     aktiv
         digitalWrite(10,HIGH); // CS blau
         digitalWrite(8,HIGH) ; // Kontroll-LED blau
         wertgruen = gruenArray[indexgruen];
         SPI.transfer(0);
         SPI.transfer(wertgruen);
         digitalWrite(6,HIGH);
         erhoeh = 0;
         verring = 0;  
  break;
  case 2 :
            if( erhoeh == 1 && indexblau < 9)
         {
          indexblau = indexblau + 1;
         }
         if (verring == 1  && indexblau > 0)
         {
          indexblau = indexblau - 1;
         }
         digitalWrite(9,HIGH);   //CS rot
         digitalWrite(5,HIGH);   // Kontrol-LED rot
         digitalWrite(6,HIGH);  //CS gruen               
         digitalWrite(7,HIGH);  //Kontroll-LED gruen     
         digitalWrite(10,LOW); // CS blau               aktiv
         digitalWrite(8,LOW) ; // Kontroll-LED blau     aktiv
         wertblau = blauArray[indexblau];
         SPI.transfer(0);
         SPI.transfer(wertblau);
         digitalWrite(10,HIGH);
         erhoeh = 0;
         verring = 0;  
  break;        
  
  }
 }
